{********************************************
; File: Scrap.p
;
;
; Copyright Apple Computer, Inc. 1986-90
; All Rights Reserved
;
********************************************}

UNIT SCRAP;
INTERFACE
USES TYPES;
CONST

{ Error Codes }
badScrapType = $1610;  { No scrap of this type. }

{ Scrap Types }
textScrap = $0000;
picScrap = $0001;
PROCEDURE GetScrap ( destHandle:Handle; scrapType:Integer)  ;
FUNCTION GetScrapCount  : Integer ;
FUNCTION GetScrapHandle ( scrapType:Integer) : handle ;
FUNCTION GetScrapPath  : Ptr ;
FUNCTION GetScrapSize ( scrapType:Integer) : Longint ;
FUNCTION GetScrapState  : Integer ;
PROCEDURE LoadScrap   ;
PROCEDURE PutScrap ( numBytes:Longint; scrapType:Integer; srcPtr:Ptr)  ;
PROCEDURE ScrapBootInit   ;
PROCEDURE ScrapReset   ;
PROCEDURE ScrapShutDown   ;
PROCEDURE ScrapStartUp   ;
FUNCTION ScrapStatus  : Boolean ;
FUNCTION ScrapVersion  : Integer ;
PROCEDURE SetScrapPath ( path:Str255)  ;
PROCEDURE UnloadScrap   ;
PROCEDURE ZeroScrap   ;
IMPLEMENTATION
END.
